-- File is ROM program for sp and gp test
-- Copyright (C) 2019  Dr. Uwe Meyer-Baese.
-- =======================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- =======================================================
ENTITY rom4096x32 IS
PORT (clk   : IN STD_LOGIC;      -- System clock
      reset : IN STD_LOGIC;      -- Asynchronous reset
      pma   : IN STD_LOGIC_VECTOR(0 TO 11); -- Program memory address
      pmd   : OUT STD_LOGIC_VECTOR(0 TO 31)); -- Program memory data
END ENTITY rom4096x32;
-- =======================================================
ARCHITECTURE fpga OF rom4096x32 IS
-- Program ROM definition and values
TYPE MEMP IS ARRAY (0 TO 4095) OF STD_LOGIC_VECTOR(0 TO 31);
CONSTANT prom : MEMP := (
X"b0000000",  --  0:	b0000000 	imm	0
X"30201858",  --  4:	30201858 	addik	r1, r0, 6232
X"3021ffec",  --  8:	addik	r1, r1, -20
-- 000003a8 <main>:
--======================================================================
--  volatile int g; // Volatile allows us to see the full assembler code
--  volatile int garray[15];
--int main(void) {
X"3021ffbc",  --  C:	addik	r1, r1, -68
X"fa610040",  --  10:	swi	r19, r1, 64
X"12610000",  --  14:	 addk	r19, r1, r0
--  volatile int s;   // Declare volatile tells compiler do
--  volatile int sarray[14]; // not try optimization
--    s = 1; // Memory location sp+4
X"30600001",  --  18:	 	addik	r3, r0, 1
X"f8730004",  --  1C:	 	swi	r3, r19, 4
--   g = 2; // Memory location gp at c20
X"30600002",  --  20:	 	addik	r3, r0, 2
X"b0000000",  --  24:	 	imm	0
X"f8600c20",  --  28:	 	swi	r3, r0, 3104	// c20 <g>
--   sarray[0] = s; // Memory location sarray[0] is sp+8
X"e8730004",  --  2C:	 	lwi	r3, r19, 4
X"f8730008",  --  30:	 	swi	r3, r19, 8
--   garray[0] = g; // Memory location garray[0] is at c24
X"b0000000",  --  34:	 	imm	0
X"e8600c20",  --  38:	 	lwi	r3, r0, 3104	// c20 <g>
X"b0000000",  --  3C:	 	imm	0
X"f8600c24",  --  40:	 	swi	r3, r0, 3108	// c24 <garray>
--   sarray[s] = 0x1357; // use variable; requires *4 for byte address
X"e8730004",  --  44:	 	lwi	r3, r19, 4
X"10631800",  --  48:	 	addk	r3, r3, r3
X"10631800",  --  4C:	 	addk	r3, r3, r3
X"30930004",  --  50:	 	addik	r4, r19, 4
X"10641800",  --  54:	 	addk	r3, r4, r3
X"30630004",  --  58:	 	addik	r3, r3, 4
X"30801357",  --  5C:	 	addik	r4, r0, 4951
X"f8830000",  --  60:	 	swi	r4, r3, 0
--   garray[g] = 0x2468; // use variable; requires *4 for byte address
X"b0000000",  --  64:	 	imm	0
X"e8600c20",  --  68:	 	lwi	r3, r0, 3104	// c20 <g>
X"10631800",  --  6C:	 	addk	r3, r3, r3
X"10631800",  --  70:	 	addk	r3, r3, r3
X"b0000000",  --  74:	 	imm	0
X"30630c24",  --  78:	 	addik	r3, r3, 3108
X"30802468",  --  7C:	 	addik	r4, r0, 9320
X"f8830000",  --  80:	 	swi	r4, r3, 0
X"10600000",  --  84:	 	addk	r3, r0, r0
--}
X"10330000",  --  88:	 	addk	r1, r19, r0
X"ea610040",  --  8C:	 	lwi	r19, r1, 64
X"30210044",  --  90:	 	addik	r1, r1, 68
X"b60f0008",  --  94:	 	rtsd	r15, 8
X"80000000",  --  98:	 	or	r0, r0, r0
--OTHERS => X"80000000"); -- default NOP
OTHERS => "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"); -- Default unknown mem

BEGIN
-- The following process will be mapped to a BlockRAM for Zynq/Virtex/Spartan
-- devices (if addr > 4 bit!) and to Distributed RAM in all other cases

prog_rom: PROCESS (reset, clk)
BEGIN
  IF reset = '0' THEN               -- Asynchronous clear
    pmd <= (OTHERS => '0');     
  ELSIF rising_edge(clk) THEN
      pmd <= prom(CONV_INTEGER(pma)); -- Read from ROM
  END IF;
END PROCESS;

END ARCHITECTURE fpga;
